package map;

/*
 * An object that maps keys (String) to values (Integer). 
 * A map cannot contain duplicate keys; 
 * each key can map to at most one value.
 */
public interface Map{

    /*
     * Associates the specified value with 
     * the specified key in this map.
     */
    Integer put(String key, Integer value);

    /*
     * Returns the value to which the specified key 
     * is mapped, or null if this map contains no mapping
     * for the key.
     */
    Integer get(String key);

    /*
     * Removes the mapping for a key from this map 
     * if it is present.
     */
    Integer remove(String key);

    /*
     * Returns a String[] view of the keys contained 
     * in this map.
     */
    String[] keySet();

    /*
     * Returns a Set view of the keys contained in this map.
     */
    boolean containsKey(String key);
}