package map;

/*
 * The bucket for the HashMap.
 * Naive implementation, just a double
 * linked list to keep all (key, value) pairs
 * that map to the same bucket.
 */
public class Bucket {

    /*
     * List's first node.
     */
    private HashNode head;

    /*
     * Number of distinct keys inside the bucket.
     */
    private int numberOfKeys = 0;

    /*
     * Given a key returns the node that contains
     * the value for this key or null if there is 
     * no value associated with the key.  
     */
    public HashNode getHashNode(String key){
	HashNode rv = null;

	if(head != null){
	    int hashCode = key.hashCode();
	    HashNode runner = head;
	    do{
		/*
		 * Berofe calling the equal methods
		 * on the keys compare the cached
		 * hash code with key.hashCode().
		 * Recall equals and hashCode are
		 * methods in class Object.
		 */
		if(runner.cachedHcv == hashCode
		   && runner.key.equals(key) ){
		    rv = runner;
		    break;
		}
		runner = runner.next;
	    }while(runner != head);
	}

	return rv;
    }

    /*
     * Appends node to the end of the list.
     */
    public void pushBack(HashNode node){
	if(node == null) return;

	if(head == null){
	    /*
	     * Empty list
	     */
	    head = node;
	    head.next = head;
	    head.prev = head;
	}
	else{
	    HashNode tmp = head.prev;
	    if(head.next == head) head.next = node;
	    head.prev = node;
	    node.next = head;
	    node.prev = tmp;

	    tmp.next = node;
	}

	numberOfKeys++;
    }

    /*
     * Removes the given node from the list.
     */
    public void removeNode(HashNode node){
	if(node == null) return;
	if(node.next == null || node.prev == null) return;


	if(node == head){
	    /*
	     * Removing the head of the list.
	     */
	        
	    /*List has only one node*/
	    if(head.next == head) head = null;
	    else{
		head = node.next;
		head.prev = node.prev;
		node.prev.next = head;
	    }
	}
	else{
	    HashNode prev = node.prev, next = node.next;

	    prev.next = next;
	    next.prev = prev;
	}

	node.next = null;
	node.prev = null;

	numberOfKeys--;
    }

    /*
     * Returns the head of the list.
     */
    public HashNode getHead(){
	return this.head;
    }

    /*
     * Returns the number of keys in this bucket.
     */
    public int getNumberOfKeys(){
	return this.numberOfKeys;
    }

}
