
public class Bucket {

    private HashNode head;

    private int numberOfKeys = 0;

    public HashNode getHashNode(String key){
        HashNode rv = null;

        if(head != null){
            int hashCode = key.hashCode();
            HashNode curr = head;
            do{
                if(curr.cachedHcv == hashCode
                   && curr.key.equals(key) ){
                    rv = curr;
                    break;
                }
                curr = curr.next;
            }while(curr != head);
        }

        return rv;
    }

    /*
     * Appends node to the end of the list.
     */
    public void pushBack(HashNode node){
        if(node == null) return;

        if(head == null){
            /*
             * Empty list
             */
            head = node;
            head.next = head;
            head.prev = head;
        }
        else{
            HashNode tmp = head.prev;
            if(head.next == head) head.next = node;
            head.prev = node;
            node.next = head;
            node.prev = tmp;

            tmp.next = node;
        }

        numberOfKeys++;
    }

    /*
     * Removes the given node from the list.
     */
    public void removeNode(HashNode node){
        if(node == null) return;
        if(node.next == null || node.prev == null) return;


        if(node == head){
            /*
             * Removing the head of the list.
             */
	        
            /*List has only one node*/
            if(head.next == head) head = null;
            else{
                head = node.next;
                head.prev = node.prev;
                node.prev.next = head;
            }
        }
        else{
            HashNode prev = node.prev, next = node.next;

            prev.next = next;
            next.prev = prev;
        }

        node.next = null;
        node.prev = null;

        numberOfKeys--;
    }

    public HashNode getHead(){
        return this.head;
    }

    public int getNumberOfKeys(){
        return this.numberOfKeys;
    }

}
