/*
 * Decompiled with CFR 0.152.
 */
package syntaxtree;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import syntaxtree.Node;
import visitor.GJNoArguVisitor;
import visitor.GJVisitor;
import visitor.GJVoidVisitor;
import visitor.Visitor;

public class NodeToken
implements Node {
    public String tokenImage;
    public Vector<NodeToken> specialTokens;
    public int beginLine;
    public int beginColumn;
    public int endLine;
    public int endColumn;
    public int kind;

    public NodeToken(String string) {
        this(string, -1, -1, -1, -1, -1);
    }

    public NodeToken(String string, int n, int n2, int n3, int n4, int n5) {
        this.tokenImage = string;
        this.specialTokens = null;
        this.kind = n;
        this.beginLine = n2;
        this.beginColumn = n3;
        this.endLine = n4;
        this.endColumn = n5;
    }

    public NodeToken getSpecialAt(int n) {
        if (this.specialTokens == null) {
            throw new NoSuchElementException("No specials in token");
        }
        return this.specialTokens.elementAt(n);
    }

    public int numSpecials() {
        if (this.specialTokens == null) {
            return 0;
        }
        return this.specialTokens.size();
    }

    public void addSpecial(NodeToken nodeToken) {
        if (this.specialTokens == null) {
            this.specialTokens = new Vector();
        }
        this.specialTokens.addElement(nodeToken);
    }

    public void trimSpecials() {
        if (this.specialTokens == null) {
            return;
        }
        this.specialTokens.trimToSize();
    }

    public String toString() {
        return this.tokenImage;
    }

    public String withSpecials() {
        if (this.specialTokens == null) {
            return this.tokenImage;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<NodeToken> enumeration = this.specialTokens.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
        }
        stringBuffer.append(this.tokenImage);
        return stringBuffer.toString();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <R, A> R accept(GJVisitor<R, A> gJVisitor, A a) {
        return gJVisitor.visit(this, a);
    }

    @Override
    public <R> R accept(GJNoArguVisitor<R> gJNoArguVisitor) {
        return gJNoArguVisitor.visit(this);
    }

    @Override
    public <A> void accept(GJVoidVisitor<A> gJVoidVisitor, A a) {
        gJVoidVisitor.visit(this, a);
    }
}

