//This program counts the occurrences of every word within a text file (program argument).


import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;

//Uncomment lines 11,12 and 23
//and comment line 24 to use Java's generic Map.
 
//import java.util.Map;
//import java.util.HashMap;
import java.io.FileNotFoundException;
import java.io.IOException;

class Count {

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Invalid number of arguments");
            System.exit(1);
        }
        //Map<String, Integer> table = new HashMap<String, Integer>();
        Map table = new HashMap(100);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(new File(args[0])));
            String line;
            while ((line = in.readLine()) != null) {
                String[] words = line.split(" ");
                for (int i = 0 ; i != words.length ; ++i) {
                    Integer count;
		    
                    if(!table.containsKey(words[i])){
                        count = 1;
                    }
                    else{
                        count = table.get(words[i]) + 1;
                    }

                    table.put(words[i], count);
                }
            }
        } 
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        catch (IOException e){
            System.err.println(e.getMessage());
            System.exit(2);
        }
        finally{
            try{
                in.close();
            }
            catch(IOException e){
                System.err.println(e.getMessage());
                System.exit(2);
            }
        }

        for (String word : table.keySet())
            System.out.println(word + ": " + table.get(word));
    }
}
