%{
	#include "example.tab.h"
	int num_lines = 1, num_chars = 0;
%}
     
letter	[A-Za-z_]
digit	[0-9]
id	{letter}({letter}|{digit})*
number	{digit}+

%%

{id}		{ return TK_ID; }
{number}	{ yylval = atof(yytext); return TK_NUM; }

	/* error cases */
{number}{id}	{ return TK_BADID; }
{id}">"{id}	{ return TK_BADID; }
"+"		{ return '+'; }
"-"		{ return '-'; }
"*"		{ return '*'; }
"/"		{ return '/'; }
"^"		{ return '^'; }
"("		{ return '('; }
")"		{ return ')'; }
";"		{ return ';'; }

\n	++num_lines; ++num_chars;
.	++num_chars;
%%

/*
<<EOF>> 	{ fclose(yyin); return TK_EOF; }
int main() {
	while (yylex());
	printf( "# of lines = %d, # of chars = %d\n", num_lines, num_chars);

	return 0;
}
*/

