/*
 * Decompiled with CFR 0.152.
 */
package visitor;

import java.util.Enumeration;
import java.util.Vector;
import syntaxtree.BinOp;
import syntaxtree.CJumpStmt;
import syntaxtree.Call;
import syntaxtree.ErrorStmt;
import syntaxtree.Exp;
import syntaxtree.Goal;
import syntaxtree.HAllocate;
import syntaxtree.HLoadStmt;
import syntaxtree.HStoreStmt;
import syntaxtree.IntegerLiteral;
import syntaxtree.JumpStmt;
import syntaxtree.Label;
import syntaxtree.MoveStmt;
import syntaxtree.NoOpStmt;
import syntaxtree.Node;
import syntaxtree.NodeListInterface;
import syntaxtree.NodeToken;
import syntaxtree.Operator;
import syntaxtree.PrintStmt;
import syntaxtree.Procedure;
import syntaxtree.Stmt;
import syntaxtree.StmtExp;
import syntaxtree.StmtList;
import syntaxtree.Temp;
import visitor.DepthFirstVisitor;
import visitor.FormatCommand;
import visitor.TreeFormatterException;

public class TreeFormatter
extends DepthFirstVisitor {
    private Vector<FormatCommand> cmdQueue = new Vector();
    private boolean lineWrap;
    private int wrapWidth;
    private int indentAmt;
    private int curLine = 1;
    private int curColumn = 1;
    private int curIndent = 0;

    public TreeFormatter() {
        this(3, 0);
    }

    public TreeFormatter(int n, int n2) {
        this.indentAmt = n;
        this.wrapWidth = n2;
        this.lineWrap = n2 > 0;
    }

    protected void processList(NodeListInterface nodeListInterface) {
        this.processList(nodeListInterface, null);
    }

    protected void processList(NodeListInterface nodeListInterface, FormatCommand formatCommand) {
        Enumeration<Node> enumeration = nodeListInterface.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().accept(this);
            if (formatCommand == null || !enumeration.hasMoreElements()) continue;
            this.cmdQueue.addElement(formatCommand);
        }
    }

    protected FormatCommand force() {
        return this.force(1);
    }

    protected FormatCommand force(int n) {
        return new FormatCommand(0, n);
    }

    protected FormatCommand indent() {
        return this.indent(1);
    }

    protected FormatCommand indent(int n) {
        return new FormatCommand(1, n);
    }

    protected FormatCommand outdent() {
        return this.outdent(1);
    }

    protected FormatCommand outdent(int n) {
        return new FormatCommand(2, n);
    }

    protected FormatCommand space() {
        return this.space(1);
    }

    protected FormatCommand space(int n) {
        return new FormatCommand(3, n);
    }

    protected void add(FormatCommand formatCommand) {
        this.cmdQueue.addElement(formatCommand);
    }

    @Override
    public void visit(NodeToken nodeToken) {
        Object object;
        Enumeration<Object> enumeration = this.cmdQueue.elements();
        block6: while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            switch (((FormatCommand)object).getCommand()) {
                case 0: {
                    this.curLine += ((FormatCommand)object).getNumCommands();
                    this.curColumn = this.curIndent + 1;
                    continue block6;
                }
                case 1: {
                    this.curIndent += this.indentAmt * ((FormatCommand)object).getNumCommands();
                    continue block6;
                }
                case 2: {
                    if (this.curIndent < this.indentAmt) continue block6;
                    this.curIndent -= this.indentAmt * ((FormatCommand)object).getNumCommands();
                    continue block6;
                }
                case 3: {
                    this.curColumn += ((FormatCommand)object).getNumCommands();
                    continue block6;
                }
            }
            throw new TreeFormatterException("Invalid value in command queue.");
        }
        this.cmdQueue.removeAllElements();
        if (nodeToken.numSpecials() > 0) {
            enumeration = nodeToken.specialTokens.elements();
            while (enumeration.hasMoreElements()) {
                object = (NodeToken)enumeration.nextElement();
                this.placeToken((NodeToken)object, this.curLine, this.curColumn);
                this.curLine = ((NodeToken)object).endLine + 1;
            }
        }
        this.placeToken(nodeToken, this.curLine, this.curColumn);
        this.curLine = nodeToken.endLine;
        this.curColumn = nodeToken.endColumn;
    }

    private void placeToken(NodeToken nodeToken, int n, int n2) {
        int n3 = nodeToken.tokenImage.length();
        if (!this.lineWrap || nodeToken.tokenImage.indexOf(10) != -1 || n2 + n3 <= this.wrapWidth) {
            nodeToken.beginColumn = n2;
        } else {
            ++n;
            nodeToken.beginColumn = n2 = this.curIndent + this.indentAmt + 1;
        }
        nodeToken.beginLine = n;
        for (int i = 0; i < n3; ++i) {
            if (nodeToken.tokenImage.charAt(i) == '\n' && i < n3 - 1) {
                ++n;
                n2 = 1;
                continue;
            }
            ++n2;
        }
        nodeToken.endLine = n;
        nodeToken.endColumn = n2;
    }

    @Override
    public void visit(Goal goal) {
        goal.f0.accept(this);
        goal.f1.accept(this);
        goal.f2.accept(this);
        if (goal.f3.present()) {
            this.processList(goal.f3);
        }
        goal.f4.accept(this);
    }

    @Override
    public void visit(StmtList stmtList) {
        if (stmtList.f0.present()) {
            this.processList(stmtList.f0);
        }
    }

    @Override
    public void visit(Procedure procedure) {
        procedure.f0.accept(this);
        procedure.f1.accept(this);
        procedure.f2.accept(this);
        procedure.f3.accept(this);
        procedure.f4.accept(this);
    }

    @Override
    public void visit(Stmt stmt) {
        stmt.f0.accept(this);
    }

    @Override
    public void visit(NoOpStmt noOpStmt) {
        noOpStmt.f0.accept(this);
    }

    @Override
    public void visit(ErrorStmt errorStmt) {
        errorStmt.f0.accept(this);
    }

    @Override
    public void visit(CJumpStmt cJumpStmt) {
        cJumpStmt.f0.accept(this);
        cJumpStmt.f1.accept(this);
        cJumpStmt.f2.accept(this);
    }

    @Override
    public void visit(JumpStmt jumpStmt) {
        jumpStmt.f0.accept(this);
        jumpStmt.f1.accept(this);
    }

    @Override
    public void visit(HStoreStmt hStoreStmt) {
        hStoreStmt.f0.accept(this);
        hStoreStmt.f1.accept(this);
        hStoreStmt.f2.accept(this);
        hStoreStmt.f3.accept(this);
    }

    @Override
    public void visit(HLoadStmt hLoadStmt) {
        hLoadStmt.f0.accept(this);
        hLoadStmt.f1.accept(this);
        hLoadStmt.f2.accept(this);
        hLoadStmt.f3.accept(this);
    }

    @Override
    public void visit(MoveStmt moveStmt) {
        moveStmt.f0.accept(this);
        moveStmt.f1.accept(this);
        moveStmt.f2.accept(this);
    }

    @Override
    public void visit(PrintStmt printStmt) {
        printStmt.f0.accept(this);
        printStmt.f1.accept(this);
    }

    @Override
    public void visit(Exp exp) {
        exp.f0.accept(this);
    }

    @Override
    public void visit(StmtExp stmtExp) {
        stmtExp.f0.accept(this);
        stmtExp.f1.accept(this);
        stmtExp.f2.accept(this);
        stmtExp.f3.accept(this);
        stmtExp.f4.accept(this);
    }

    @Override
    public void visit(Call call) {
        call.f0.accept(this);
        call.f1.accept(this);
        call.f2.accept(this);
        if (call.f3.present()) {
            this.processList(call.f3);
        }
        call.f4.accept(this);
    }

    @Override
    public void visit(HAllocate hAllocate) {
        hAllocate.f0.accept(this);
        hAllocate.f1.accept(this);
    }

    @Override
    public void visit(BinOp binOp) {
        binOp.f0.accept(this);
        binOp.f1.accept(this);
        binOp.f2.accept(this);
    }

    @Override
    public void visit(Operator operator) {
        operator.f0.accept(this);
    }

    @Override
    public void visit(Temp temp) {
        temp.f0.accept(this);
        temp.f1.accept(this);
    }

    @Override
    public void visit(IntegerLiteral integerLiteral) {
        integerLiteral.f0.accept(this);
    }

    @Override
    public void visit(Label label) {
        label.f0.accept(this);
    }
}

