import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
/*
import java.util.Map;
import java.util.HashMap;
*/
// To use the Java Generic HashMap (line 23), un-comment the above segment
// and comment the below.
// /*
import map.Map;
import map.HashMap;
// */

/*
 * Counting word occurances inside a file.
 */
class Count {

    public static void main(String[] args) {
	//In Java every array has a field for its length.
	if (args.length > 1) {
	    System.err.println("Usage: java Count <filename>");
	    System.exit(1);
	}
	//Map<String, Integer> table = new HashMap<String, Integer>();
	/*
	 * Constructing a Map that holds for every String 
	 * how many times apears inside the file. 
	 */
	Map table = new HashMap(100);
	BufferedReader in = null;
	try {
	    /*
	     * Opening the input file denoted by argv[0].
	     * -Google: java 7 File, FileReader and BufferedReader for their APIs
	     * -Try to give a file that does not exist ...
	     */
	    in = new BufferedReader(new FileReader(new File(args[0])));
	    String line;
	    /*
	     * For all lines in the input file.
	     */
	    while ((line = in.readLine()) != null) {
		/* Split line around ' ' and get all its words.
		 * Naive way to split the line, because it does not
		 * take into consideration punctuation marks (e.g., '.', ',', etc.).
		 */
		String[] words = line.split(" ");

		/*
		 * For all words 
		 */
		for (int i = 0 ; i != words.length ; ++i) {
		    Integer count;
		    
		    /*If word is not inside the map then start count to 1*/
		    if(!table.containsKey(words[i])){
			count = 1;
		    }
		    /*Otherwise increase the stored value by 1*/
		    else{
			count = table.get(words[i]) + 1;
		    }

		    /*And update the value for the current word*/
		    table.put(words[i], count);
		}
	    }
	}
	/*Handling all the exceptions tha the above try block throws*/
	catch (FileNotFoundException e) {
	    System.err.println(e.getMessage());
	    System.exit(2);
	}
	catch (IOException e){
	    System.err.println(e.getMessage());
	    System.exit(2);
	}
	/*A finally block, after a try-catch, always executes when the try-catch exits*/
	finally{
	    try{
		/*Closing the input stream, which also throws an Exception.*/
		in.close();
	    }
	    catch(IOException e){
		System.err.println(e.getMessage());
		System.exit(2);
	    }
	}

	/*
	 * Pretty cool way to iterate over an Array, Set, Collection, etc.
	 * No need for an auxiliary variable (i.e., for(int i = 0; ... ))
	 * to index the data structure ...
	 */
	for (String word : table.keySet())
	    System.out.println(word + ": " + table.get(word));
    }
}