import tree.*;
import java.io.InputStream;
import java.io.IOException;
import visitors.*;

class TernaryOperator {

    private int lookaheadToken;

    private InputStream in;

    public TernaryOperator(InputStream in) throws IOException {
	this.in = in;
	lookaheadToken = in.read();
    }

    private void consume(int symbol) throws IOException, ParseError {
	if (lookaheadToken != symbol)
	    throw new ParseError();
	lookaheadToken = in.read();
    }

    private TernNode Tern() throws IOException, ParseError {
	if(lookaheadToken < '0' || lookaheadToken > '9')
	    throw new ParseError();
	int number = this.lookaheadToken;
	consume(lookaheadToken);
	TernTailNode ternTail = TernTail();

	return new TernNode(number, ternTail);
    }

    private TernTailNode TernTail() throws IOException, ParseError {
	if(lookaheadToken == ':' || lookaheadToken == '\n' || lookaheadToken == -1)
	    return new TernTailAlt2();
	if(lookaheadToken != '?')
	    throw new ParseError();

	int qMark = this.lookaheadToken;
	consume('?');
	
	TernNode thenPart = Tern();
	
	int semiC = this.lookaheadToken;
	consume(':');
	
	TernNode elsePart = Tern();

	return new TernTailAlt1(qMark, thenPart, semiC, elsePart);
    }

    public TernNode parse() throws IOException, ParseError {
	TernNode rv = Tern();
	if (lookaheadToken != '\n' && lookaheadToken != -1)
	    throw new ParseError();
	return rv;
    }

    public static void main(String[] args) {
	try {
	    TernaryOperator parser = new TernaryOperator(System.in);
	    TernNode root = parser.parse();
	    PrintVisitor pVis = new PrintVisitor();
	    EvalVisitor evVis = new EvalVisitor();
	    root.accept(pVis);
	    System.out.println();
	    System.out.println(root.accept(evVis, 0));
	}
	catch (IOException e) {
	    System.err.println(e.getMessage());
	}
	catch(ParseError err){
	    System.err.println(err.getMessage());
	}
    }
}

