%{
       #include <math.h>
       #include <stdio.h>
      
       #define YYSTYPE double

       void yyerror (char const *s);
       extern int num_lines;
%}
     %error-verbose

     /* Bison declarations.  */
     %token TK_NUM TK_ID TK_BADID
     %left '-' '+'
     %left '*' '/'
     %left TK_NEG     /* negation--unary minus */
     %right '^'    /* exponentiation */
     
%% /* The grammar follows.  */
     input:    /* empty */
             | input line
     ;
     
     line:     ';'
             | exp ';'
             | exp error exp ';' {yyerror("missing arithmetic operator or ';'"); yyerrok;}
	     | error ';' {yyerrok;}
     ;
     
     exp: TK_NUM {$$=$1;} | TK_ID 
	     | TK_BADID			{yyerror("invalid ID"); YYERROR; yyerrok;}
             | exp '+' exp 		{$$=$1 + $3; printf("exp + exp\n");}
             | exp '-' exp 		{$$=$1 - $3; printf("exp - exp\n");}
             | exp '*' exp 		{$$=$1 * $3; printf("exp * exp\n");}
             | exp '/' exp 		{$$=$1 / $3; printf("exp / exp\n");}
             | '-' exp  %prec TK_NEG 	{$$=-$2; printf("-exp\n");}
             | exp '^' exp 		{$$=pow($1, $3); printf("exp ^ exp\n");}
             | '(' exp ')' 		{$$=$2; printf("( exp )\n");}
             | '(' exp error		{yyerror("Missing operator ')'"); yyerrok;}
     ;

%%

/*
             | '(' exp error		{yyerror("Missing operator ')'"); yyerrok;}
*/
int main(void) {
	return yyparse();
}


void yyerror (char const *s)
{
	printf ("%d: %s\n", num_lines, s);
}
