import syntaxtree.*;
import visitor.GJDepthFirst;

public class EvalVisitor extends GJDepthFirst<Integer, Integer>{


    public Integer visit(Goal n, Integer _){
	return n.f0.accept(this, null);
    }

    public Integer visit(Exp n, Integer _){
	Integer term = n.f0.accept(this, null);
	if(n.f1.present())
	    return n.f1.node.accept(this, term);
	else
	    return term;
    }

    public Integer visit(PlusExp n, Integer lTerm){
	Integer rTerm = n.f1.accept(this, null);
	Integer rv = lTerm + rTerm;
	if(n.f2.present()){
	    rv = n.f2.accept(this, rv);
	}
	return rv;
    }

    public Integer visit(MinusExp n, Integer lTerm){
	Integer rTerm = n.f1.accept(this, null);
	Integer rv = lTerm - rTerm;
	if(n.f2.present()){
	    rv = n.f2.accept(this, rv);
	}
	return rv;
    }

    public Integer visit(Term n, Integer _){
	Integer factor = n.f0.accept(this, null);
	if(n.f1.present())
	    return n.f1.accept(this, factor);
	else 
	    return factor;
    }

    public Integer visit(TimesExp n, Integer lFactor){
	Integer rFactor = n.f1.accept(this, null);
	Integer rv = lFactor * rFactor;
	if(n.f2.present())
	    rv = n.f2.accept(this, rv);
	return rv;
    }

    public Integer visit(DivExp n, Integer lFactor){
	Integer rFactor = n.f1.accept(this, null);
	Integer rv = lFactor / rFactor;
	if(n.f2.present())
	    rv = n.f2.accept(this, rv);
	return rv;
    }

    public Integer visit(Num n, Integer _){
	return Integer.parseInt(n.f0.toString());
    }

    

}