/**
 * Copyright (c) 2004,2005 UCLA Compilers Group. 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *  Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 * 
 *  Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 * 
 *  Neither UCLA nor the names of its contributors may be used to endorse 
 *  or promote products derived from this software without specific prior 
 *  written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **/

/*
 * All files in the distribution of JTB, The Java Tree Builder are 
 * Copyright 1997, 1998, 1999 by the Purdue Research Foundation of Purdue
 * University.  All rights reserved.
 * 
 * Redistribution and use in source and binary forms are permitted 
 * provided that this entire copyright notice is duplicated in all 
 * such copies, and that any documentation, announcements, and 
 * other materials related to such distribution and use acknowledge 
 * that the software was developed at Purdue University, West Lafayette,
 * Indiana by Kevin Tao, Wanjun Wang and Jens Palsberg.  No charge may 
 * be made for copies, derivations, or distributions of this material
 * without the express written consent of the copyright holder.  
 * Neither the name of the University nor the name of the author 
 * may be used to endorse or promote products derived from this 
 * material without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
 */

package EDU.purdue.jtb.misc;

/**
 * Class Globals contains global program information.
 */
public class Globals {
   //
   // Global constants
   //
   public static final String progName = "JTB";
   public static final String scriptName = "jtb";
   public static final String version = "1.3.2 DIT@UoA patched";
   public static final String author = "Wanjun Wang, Kevin Tao, Vids Samanta";
   public static final String email = "wanjun@purdue.edu, vids@ucla.edu";

   public static String fileHeader() {
      return fileHeader(new Spacing(3));
   }
   public static String fileHeader(Spacing spc) {
      return
         "//\n" +
         spc.spc + "// Generated by " + progName + " " + version + "\n" +
         spc.spc + "//";
   }

   //
   // Internal name constants
   //
   // TO DO -- remove all hard-coded names from source files.
   //
   public static final String nodeName = "Node";
   public static final String listInterfaceName = "NodeListInterface";
   public static final String choiceName = "NodeChoice";
   public static final String listName = "NodeList";
   public static final String listOptName = "NodeListOptional";
   public static final String optionalName = "NodeOptional";
   public static final String sequenceName = "NodeSequence";
   public static final String tokenName = "NodeToken";

   public static final String visitorName = "Visitor";
   public static final String GJVisitorName = "GJVisitor";
   public static final String GJNoArguVisitorName = "GJNoArguVisitor";
   public static final String GJVoidVisitorName = "GJVoidVisitor";

   //
   // Changeable flags
   //
   public static boolean printClassList = false;
   public static boolean generateFiles = true;
   public static boolean printGrammarToOut = false;
//   public static boolean oldVisitNames = false;
   public static boolean noOverwrite = false;
   public static boolean noSemanticCheck = false;
   public static boolean javaDocComments = false;
   public static boolean descriptiveFieldNames = false;
   public static boolean parentPointers = false;
   public static boolean keepSpecialTokens = false;
   // Exceptions
   public static boolean throwsException = false;
   public static String throwsException() {
      if (throwsException)
         return " throws Exception";
      return "";
   }

   public static boolean schemeToolkit = false;
   public static boolean printerToolkit = false;

   //
   // Changeable names
   //
   public static String nodePackage = "syntaxtree";
   public static String visitorPackage = "visitor";
   public static String nodeDir = "syntaxtree";
   public static String visitorDir = "visitor";
   public static String nodeSuperclass = null;

   public static String inFilename;                   // must be set in main()
   public static String outFilename;

   //
   // These two methods should be called rather than setting nodePackage
   // and visitorPackage directly.
   //
   public static void setNodePackage(String s) {
      int lastDotIndex = -1;
      nodePackage = s;
      
      for ( int i = 0; i < s.length(); ++i )
         if ( s.charAt(i) == '.' ) lastDotIndex = i;

      if ( lastDotIndex != -1 )
         nodeDir = s.substring(lastDotIndex + 1);
      else
         nodeDir = s;
   }
   
   public static void setVisitorPackage(String s) {
      int lastDotIndex = -1;
      visitorPackage = s;
      
      for ( int i = 0; i < s.length(); ++i )
         if ( s.charAt(i) == '.' ) lastDotIndex = i;

      if ( lastDotIndex != -1 )
         visitorDir = s.substring(lastDotIndex + 1);
      else
         visitorDir = s;
   }
}
