
public class HashMap implements Map{

    Bucket[] buckets;

    private Bucket getBucket(String key){
        int bucketNo = key.hashCode() % buckets.length;
        if(bucketNo < 0) bucketNo = -bucketNo;
        return this.buckets[bucketNo];
    }

    public HashMap(int size){

        buckets = new Bucket[size];

        for(int i = 0 ; i < size ; ++i){
            buckets[i] = new Bucket();
        }
    }

    public Integer put(String key, Integer value){

        Integer rv = null;

        Bucket b = this.getBucket(key);

        HashNode n = b.getHashNode(key);

        if(n == null){
            n = new HashNode(key, value);
            b.pushBack(n);
        }
        else{
            rv = n.value;
            n.value = value;
        }

        return rv;
    }

    public Integer get(String key){

        Integer rv = null;

        HashNode n = this.getBucket(key).getHashNode(key);

        if(n != null){
            rv = n.value;
        }

        return rv;
    }

    public Integer remove(String key){
        Bucket b = this.getBucket(key);

        Integer rv = null;

        HashNode n = b.getHashNode(key);

        if(n != null){
            rv = n.value;
            b.removeNode(n);
        }

        return rv;
    }

    public String[] keySet(){
        int totalNumberOfKeys = 0;

        for(int i = 0 ; i < buckets.length ; ++i){
            totalNumberOfKeys += this.buckets[i].getNumberOfKeys();
        }

        String[] rv = new String[totalNumberOfKeys];

        int currIndex = 0;

        for(int i = 0 ; i < buckets.length ; ++i){
            HashNode bucketList = this.buckets[i].getHead();
            HashNode curr = bucketList;
            if(bucketList != null){
                do{
                    rv[currIndex++] = curr.key;
                    curr = curr.next;
                }while(curr != bucketList);
            }
        }
        return rv;
    }

    public boolean containsKey(String key){
        return this.get(key) != null;
    }

}
