package map;

/*
 * Hash table based implementation of the Map interface.
 */
public class HashMap implements Map{

    /*
     * The hash table. An array of buckets.
     */
    Bucket[] buckets;

    /*
     * The size of the table.
     */
    int size;

    /*
     * Returns the Bucket object that may contain
     * the given key.
     */
    private Bucket getBucket(String key){
	/*limit hash from 0 to size-1*/
	int bucketNo = key.hashCode() % size;
	/*hashCode returns a negative number*/
	if(bucketNo < 0) bucketNo = bucketNo*-1;
	return this.buckets[bucketNo];
    }

    /*
     * Constructs a HashMap with the given size.
     */
    public HashMap(int size){
	this.size = size;
	buckets = new Bucket[size];

	for(int i = 0 ; i < size ; ++i){
	    buckets[i] = new Bucket();
	}
    }

    /*
     * Returns the previous value associated with the 
     * key or null if there is no value maped to the key.
     */
    public Integer put(String key, Integer value){

	Integer rv = null;

	Bucket b = this.getBucket(key);

	HashNode n = b.getHashNode(key);

	if(n == null){
	    n = new HashNode(key, value);
	    b.pushBack(n);
	}
	else{
	    rv = n.value;
	    n.value = value;
	}

	return rv;
    }

    public Integer get(String key){

	Integer rv = null;

	HashNode n = this.getBucket(key).getHashNode(key);

	if(n != null){
	    rv = n.value;
	}

	return rv;
    }

    public Integer remove(String key){
	Bucket b = this.getBucket(key);

	Integer rv = null;

	HashNode n = b.getHashNode(key);

	if(n != null){
	    rv = n.value;
	    b.removeNode(n);
	}

	return rv;
    }

    public String[] keySet(){
	int totalNumberOfKeys = 0;

	for(int i = 0 ; i < size ; ++i){
	    totalNumberOfKeys += this.buckets[i].getNumberOfKeys();
	}

	String[] rv = new String[totalNumberOfKeys];

	int currIndex = 0;

	for(int i = 0 ; i < size ; ++i){
	    HashNode bucketList = this.buckets[i].getHead();
	    if(bucketList == null) continue;
	    HashNode runner = bucketList;
	    do{
		rv[currIndex++] = runner.key;
		runner = runner.next;
	    }while(runner != bucketList);
	}
	return rv;
    }

    public boolean containsKey(String key){
	return this.get(key) != null;
    }

}