/*
 * Decompiled with CFR 0.152.
 */
package visitor;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import syntaxtree.NodeToken;
import visitor.DepthFirstVisitor;

public class TreeDumper
extends DepthFirstVisitor {
    protected PrintWriter out;
    private int curLine = 1;
    private int curColumn = 1;
    private boolean startAtNextToken = false;
    private boolean printSpecials = true;

    public TreeDumper() {
        this.out = new PrintWriter(System.out, true);
    }

    public TreeDumper(Writer writer) {
        this.out = new PrintWriter(writer, true);
    }

    public TreeDumper(OutputStream outputStream) {
        this.out = new PrintWriter(outputStream, true);
    }

    public void flushWriter() {
        this.out.flush();
    }

    public void printSpecials(boolean bl) {
        this.printSpecials = bl;
    }

    public void startAtNextToken() {
        this.startAtNextToken = true;
    }

    public void resetPosition() {
        this.curColumn = 1;
        this.curLine = 1;
    }

    @Override
    public void visit(NodeToken nodeToken) {
        if (nodeToken.beginLine == -1 || nodeToken.beginColumn == -1) {
            this.printToken(nodeToken.tokenImage);
            return;
        }
        if (this.printSpecials && nodeToken.numSpecials() > 0) {
            Enumeration<NodeToken> enumeration = nodeToken.specialTokens.elements();
            while (enumeration.hasMoreElements()) {
                this.visit(enumeration.nextElement());
            }
        }
        if (this.startAtNextToken) {
            this.curLine = nodeToken.beginLine;
            this.curColumn = 1;
            this.startAtNextToken = false;
            if (nodeToken.beginColumn < this.curColumn) {
                this.out.println();
            }
        }
        if (nodeToken.beginLine < this.curLine) {
            throw new IllegalStateException("at token \"" + nodeToken.tokenImage + "\", n.beginLine = " + Integer.toString(nodeToken.beginLine) + ", curLine = " + Integer.toString(this.curLine));
        }
        if (nodeToken.beginLine == this.curLine && nodeToken.beginColumn < this.curColumn) {
            throw new IllegalStateException("at token \"" + nodeToken.tokenImage + "\", n.beginColumn = " + Integer.toString(nodeToken.beginColumn) + ", curColumn = " + Integer.toString(this.curColumn));
        }
        if (this.curLine < nodeToken.beginLine) {
            this.curColumn = 1;
            while (this.curLine < nodeToken.beginLine) {
                this.out.println();
                ++this.curLine;
            }
        }
        while (this.curColumn < nodeToken.beginColumn) {
            this.out.print(" ");
            ++this.curColumn;
        }
        this.printToken(nodeToken.tokenImage);
    }

    private void printToken(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                ++this.curLine;
                this.curColumn = 1;
            } else {
                ++this.curColumn;
            }
            this.out.print(string.charAt(i));
        }
        this.out.flush();
    }
}

